﻿using AZVIC.Ei8htPOS.POSRetail.Constants;
using AZVIC.Ei8htPOS.BAL;
using AZVIC.Ei8htPOS.Entities;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Controls;
using System.Windows.Data;

namespace AZVIC.Ei8htPOS.POSRetail.Converters
{
    public class InventoryConverter : BaseConverter, IValueConverter
    {
        public object Convert(object value, Type targetType, object parameter, System.Globalization.CultureInfo culture)
        {
            if (value.GetType() == typeof(DataGridRow))
            {
                DataGridRow row = value as DataGridRow;
                if (row != null && AppSession.ProductsList != null)
                    return AppSession.ProductsList.IndexOf(row.DataContext as Products) + 1;
                else
                    return -1;
            }
            else
            {
                Guid val = Guid.Parse(value.ToString());
                if (val != null)
                {
                    switch (parameter.ToString())
                    {
                        case UIConstants.BRAND:
                            return AppSession.BrandList.Where(a => a.UniqueID == val).Select(a => a.BrandName).Count() > 0 ? 
                                AppSession.BrandList.Where(a => a.UniqueID == val).Select(a => a.BrandName).Single() : string.Empty;
                        case UIConstants.COLOR:
                            return AppSession.ColorList.Where(a => a.UniqueID == val).Select(a => a.ColorName).Count() > 0 ? 
                                AppSession.ColorList.Where(a => a.UniqueID == val).Select(a => a.ColorName).Single() : string.Empty;
                        case UIConstants.SIZE:
                            return AppSession.MeasurementList.Where(a => a.UniqueID == val).Select(a => a.MeasurementName).Count() > 0 ?
                                AppSession.MeasurementList.Where(a => a.UniqueID == val).Select(a => a.MeasurementName).Single() : string.Empty;
                        default: return string.Empty;
                    }
                }
            }
            return string.Empty;
        }

        public object ConvertBack(object value, Type targetType, object parameter, System.Globalization.CultureInfo culture)
        {
            throw new NotImplementedException();
        }
    }
}
